
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Define variables
L = model.addVar(name="hours_worked_by_Laura", lb=0)  # Assuming hours cannot be negative
R = model.addVar(name="hours_worked_by_Ringo", lb=0)  # Assuming hours cannot be negative

# Objective function
model.setObjective(8.02 * L + 3.31 * R, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(12 * L + 1 * R >= 68, name="likelihood_to_quit")
model.addConstr(13 * L + 17 * R >= 44, name="paperwork_competence")
model.addConstr(16 * L + 16 * R >= 38, name="work_quality")
model.addConstr(-5 * L + 2 * R >= 0, name="hours_tradeoff")
model.addConstr(12 * L + 1 * R <= 151, name="likelihood_to_quit_upper")
model.addConstr(13 * L + 17 * R <= 102, name="paperwork_competence_upper")
model.addConstr(16 * L + 16 * R <= 187, name="work_quality_upper")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by Laura: {L.varValue}")
    print(f"Hours worked by Ringo: {R.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
