
from gurobipy import Model, GRB

# Create a new model
m = Model("resource_allocation")

# Create variables
logistics_companies = m.addVar(vtype=GRB.INTEGER, name="x0")
mechanized_infantry_companies = m.addVar(vtype=GRB.INTEGER, name="x1")
pathfinder_teams = m.addVar(vtype=GRB.INTEGER, name="x2")

# Set objective function
m.setObjective(4 * logistics_companies**2 + 2 * logistics_companies * mechanized_infantry_companies + 2 * mechanized_infantry_companies**2 + 2 * logistics_companies + 5 * pathfinder_teams, GRB.MINIMIZE)

# Add constraints
m.addConstr(1.31 * logistics_companies + 5.74 * mechanized_infantry_companies >= 85, "c0")
m.addConstr(1.31 * logistics_companies + 7.85 * pathfinder_teams >= 102, "c1")
m.addConstr(1.31 * logistics_companies + 5.74 * mechanized_infantry_companies + 7.85 * pathfinder_teams >= 102, "c2")
m.addConstr(5.2 * mechanized_infantry_companies + 0.69 * pathfinder_teams >= 28, "c3")
m.addConstr(0.44 * logistics_companies + 0.69 * pathfinder_teams >= 29, "c4")
m.addConstr(0.44 * logistics_companies + 5.2 * mechanized_infantry_companies + 0.69 * pathfinder_teams >= 29, "c5")
m.addConstr(1.17 * mechanized_infantry_companies + 1.66 * pathfinder_teams >= 156, "c6")
m.addConstr(4.18 * logistics_companies + 1.17 * mechanized_infantry_companies + 1.66 * pathfinder_teams >= 156, "c7")
m.addConstr(3 * mechanized_infantry_companies**2 - 6 * pathfinder_teams**2 >= 0, "c8")
m.addConstr(5.2 * mechanized_infantry_companies + 0.69 * pathfinder_teams <= 201, "c9")
m.addConstr(4.18 * logistics_companies + 1.66 * pathfinder_teams <= 249, "c10")
m.addConstr(1.17 * mechanized_infantry_companies**2 + 1.66 * pathfinder_teams**2 <= 320, "c11")
m.addConstr(4.18 * logistics_companies**2 + 1.17 * mechanized_infantry_companies**2 + 1.66 * pathfinder_teams**2 <= 233, "c12")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('logistics_companies:', logistics_companies.x)
    print('mechanized_infantry_companies:', mechanized_infantry_companies.x)
    print('pathfinder_teams:', pathfinder_teams.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
