
import gurobi as gp

# Define variables
logistics_companies = gp.Var(name="logistics_companies", lowBound=0, vtype=gp.GRB.INTEGER)
mechanized_infantry_companies = gp.Var(name="mechanized_infantry_companies", lowBound=0, vtype=gp.GRB.INTEGER)
pathfinder_teams = gp.Var(name="pathfinder_teams", lowBound=0, vtype=gp.GRB.INTEGER)

# Create model
m = gp.Model()

# Define objective function
m.setObjective(4 * logistics_companies**2 + 2 * logistics_companies * mechanized_infantry_companies + 
               2 * mechanized_infantry_companies**2 + 2 * logistics_companies + 5 * pathfinder_teams, gp.GRB.MINIMIZE)

# Define constraints
m.addConstr(1.31 * logistics_companies + 5.74 * mechanized_infantry_companies >= 85)
m.addConstr(1.31 * logistics_companies + 7.85 * pathfinder_teams >= 102)
m.addConstr(1.31 * logistics_companies + 5.74 * mechanized_infantry_companies + 7.85 * pathfinder_teams >= 102)
m.addConstr(5.2 * mechanized_infantry_companies + 0.69 * pathfinder_teams >= 28)
m.addConstr(0.44 * logistics_companies + 0.69 * pathfinder_teams >= 29)
m.addConstr(0.44 * logistics_companies + 5.2 * mechanized_infantry_companies + 0.69 * pathfinder_teams >= 29)
m.addConstr(1.17 * mechanized_infantry_companies + 1.66 * pathfinder_teams >= 156)
m.addConstr(4.18 * logistics_companies + 1.17 * mechanized_infantry_companies + 1.66 * pathfinder_teams >= 156)
m.addConstr(3 * mechanized_infantry_companies**2 - 6 * pathfinder_teams**2 >= 0)
m.addConstr(5.2 * mechanized_infantry_companies + 0.69 * pathfinder_teams <= 201)
m.addConstr(4.18 * logistics_companies + 1.66 * pathfinder_teams <= 249)
m.addConstr((1.17 * mechanized_infantry_companies)**2 + (1.66 * pathfinder_teams)**2 <= 320)
m.addConstr((4.18 * logistics_companies)**2 + (1.17 * mechanized_infantry_companies)**2 + (1.66 * pathfinder_teams)**2 <= 233)

# Solve model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Logistics companies:", logistics_companies.varValue)
    print("Mechanized infantry companies:", mechanized_infantry_companies.varValue)
    print("Pathfinder teams:", pathfinder_teams.varValue)
    print("Objective:", m.objVal)
else:
    print("No optimal solution found")
