
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
ramen = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bowls_of_instant_ramen")
hotdogs = m.addVar(lb=0, vtype=GRB.INTEGER, name="hot_dogs")

# Set objective function
m.setObjective(6.45 * ramen * hotdogs + 2.48 * hotdogs, GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * ramen + 6 * hotdogs >= 61, "tastiness_min")
m.addConstr(-6 * ramen + 7 * hotdogs >= 0, "ramen_hotdog_ratio")
m.addConstr(5*ramen + 6*hotdogs <= 175, "tastiness_upper_bound") # derived from resource constraints
m.addConstr((5 * ramen) * (5*ramen) + (6 * hotdogs) * (6*hotdogs) <= 122, "tastiness_squared")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Bowls of instant ramen: {ramen.x}")
    print(f"Hot dogs: {hotdogs.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

