
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="bowls_of_instant_ramen")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="hot_dogs")

# Objective function
m.setObjective(6.45*x0*x1 + 2.48*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(5*x0 + 6*x1 >= 61, "tastiness_rating_constraint")
m.addConstr(-6*x0 + 7*x1 >= 0, "linear_constraint")
m.addConstr(25*x0**2 + 36*x1**2 <= 122, "quadratic_tastiness_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of bowls of instant ramen: {x0.x}")
    print(f"Number of hot dogs: {int(x1.x)}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
