
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="bowls_of_instant_ramen")
    x1 = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, name="hot_dogs", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(6.45 * x0 * x1 + 2.48 * x1, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5 * x0 + 6 * x1 >= 61, name="tastiness_rating_min")
    model.addConstr(-6 * x0 + 7 * x1 >= 0, name="linear_constraint")
    model.addConstr(5 * x0 >= 0) # Not required but added for clarity on x0's domain
    model.addConstr(25 * x0**2 + 36 * x1**2 <= 122, name="tastiness_rating_squared_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"bowls of instant ramen: {x0.varValue}")
        print(f"hot dogs: {x1.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
