
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
pasta = m.addVar(vtype=gp.GRB.INTEGER, name="bowls_of_pasta")
sandwiches = m.addVar(vtype=gp.GRB.CONTINUOUS, name="ham_sandwiches")
milkshakes = m.addVar(vtype=gp.GRB.CONTINUOUS, name="milkshakes")
bacon = m.addVar(vtype=gp.GRB.CONTINUOUS, name="strips_of_bacon")

# Set objective function
m.setObjective(9 * pasta + 7 * sandwiches + 7 * milkshakes + 6 * bacon, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.47 * sandwiches + 7.28 * milkshakes >= 28, "fiber_constraint1")
m.addConstr(5.6 * pasta + 1.47 * sandwiches >= 9, "fiber_constraint2")
m.addConstr(1.47 * sandwiches + 4.38 * bacon >= 28, "fiber_constraint3")
m.addConstr(5.6 * pasta + 7.28 * milkshakes >= 17, "fiber_constraint4")
m.addConstr(6.23 * milkshakes + 1.15 * bacon >= 9, "sourness_constraint1")
m.addConstr(4.32 * pasta + 6.23 * milkshakes >= 19, "sourness_constraint2")
m.addConstr(4.32 * pasta + 1.15 * bacon >= 8, "sourness_constraint3")
m.addConstr(3.11 * sandwiches + 6.23 * milkshakes >= 20, "sourness_constraint4")
m.addConstr(4.32 * pasta + 3.11 * sandwiches + 6.23 * milkshakes >= 15, "sourness_constraint5")
m.addConstr(1.47 * sandwiches + 7.28 * milkshakes <= 66, "fiber_constraint5")
m.addConstr(5.6 * pasta + 1.47 * sandwiches <= 51, "fiber_constraint6")
m.addConstr(5.6 * pasta + 4.38 * bacon <= 85, "fiber_constraint7")
m.addConstr(5.6 * pasta + 1.47 * sandwiches + 7.28 * milkshakes + 4.38 * bacon <= 85, "fiber_constraint8")  # Corrected constraint
m.addConstr(4.32 * pasta + 3.11 * sandwiches <= 71, "sourness_constraint6")
m.addConstr(6.23 * milkshakes + 1.15 * bacon <= 37, "sourness_constraint7")
m.addConstr(3.11 * sandwiches + 1.15 * bacon <= 30, "sourness_constraint8")
m.addConstr(4.32 * pasta + 6.23 * milkshakes <= 65, "sourness_constraint9")
m.addConstr(4.32 * pasta + 3.11 * sandwiches + 6.23 * milkshakes + 1.15 * bacon <= 65, "sourness_constraint10")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

