
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="bowls_of_pasta", vtype=gp.GRB.INTEGER)  # integer
x1 = m.addVar(name="ham_sandwiches")  # continuous
x2 = m.addVar(name="milkshakes")  # continuous
x3 = m.addVar(name="strips_of_bacon")  # continuous

# Objective function
m.setObjective(9 * x0 + 7 * x1 + 7 * x2 + 6 * x3, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(5.6 * x0 + 1.47 * x1 + 7.28 * x2 + 4.38 * x3 <= 113)  # fiber
m.addConstr(4.32 * x0 + 3.11 * x1 + 6.23 * x2 + 1.15 * x3 <= 85)  # sourness

m.addConstr(1.47 * x1 + 7.28 * x2 >= 28)  # fiber from ham sandwiches and milkshakes
m.addConstr(5.6 * x0 + 1.47 * x1 >= 9)  # fiber from bowls of pasta and ham sandwiches
m.addConstr(1.47 * x1 + 4.38 * x3 >= 28)  # fiber from ham sandwiches and strips of bacon
m.addConstr(5.6 * x0 + 7.28 * x2 >= 17)  # fiber from bowls of pasta and milkshakes
m.addConstr(6.23 * x2 + 1.15 * x3 >= 9)  # sourness from milkshakes and strips of bacon
m.addConstr(4.32 * x0 + 6.23 * x2 >= 19)  # sourness from bowls of pasta and milkshakes
m.addConstr(4.32 * x0 + 1.15 * x3 >= 8)  # sourness from bowls of pasta and strips of bacon
m.addConstr(3.11 * x1 + 6.23 * x2 >= 20)  # sourness from ham sandwiches and milkshakes
m.addConstr(4.32 * x0 + 3.11 * x1 + 6.23 * x2 >= 15)  # sourness from bowls of pasta, ham sandwiches, and milkshakes

m.addConstr(1.47 * x1 + 7.28 * x2 <= 66)  # fiber from ham sandwiches and milkshakes
m.addConstr(5.6 * x0 + 1.47 * x1 <= 51)  # fiber from bowls of pasta and ham sandwiches
m.addConstr(5.6 * x0 + 4.38 * x3 <= 85)  # fiber from bowls of pasta and strips of bacon
m.addConstr(5.6 * x0 + 1.47 * x1 + 7.28 * x2 + 4.38 * x3 <= 85)  # total fiber

m.addConstr(4.32 * x0 + 3.11 * x1 <= 71)  # sourness from bowls of pasta and ham sandwiches
m.addConstr(6.23 * x2 + 1.15 * x3 <= 37)  # sourness from milkshakes and strips of bacon
m.addConstr(3.11 * x1 + 1.15 * x3 <= 30)  # sourness from ham sandwiches and strips of bacon
m.addConstr(4.32 * x0 + 6.23 * x2 <= 65)  # sourness from bowls of pasta and milkshakes
m.addConstr(4.32 * x0 + 3.11 * x1 + 6.23 * x2 + 1.15 * x3 <= 65)  # total sourness

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"bowls of pasta: {x0.varValue}")
    print(f"ham sandwiches: {x1.varValue}")
    print(f"milkshakes: {x2.varValue}")
    print(f"strips of bacon: {x3.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
