
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = {}
variables = ['rubber gloves', 'packs of napkins', 'paper towel rolls', 'cartons of milk', 'bottles of ibuprofen']
for i, var_name in enumerate(variables):
    x[i] = m.addVar(vtype=GRB.INTEGER, name=var_name)

# Set objective function
m.setObjective(5.13 * x[0] + 2.16 * x[1] + 4.35 * x[2] + 7.67 * x[3] + 8.66 * x[4], GRB.MAXIMIZE)

# Resource constraints
resources = {
    'r0': {'description': 'sustainability score', 'upper_bound': 99, 'x0': 5, 'x1': 7, 'x2': 2, 'x3': 4, 'x4': 2},
    'r1': {'description': 'storage space', 'upper_bound': 87, 'x0': 7, 'x1': 4, 'x2': 2, 'x3': 3, 'x4': 2},
    'r2': {'description': 'portability rating', 'upper_bound': 83, 'x0': 8, 'x1': 2, 'x2': 7, 'x3': 1, 'x4': 8},
    'r3': {'description': 'dollar value', 'upper_bound': 92, 'x0': 1, 'x1': 7, 'x2': 3, 'x3': 5, 'x4': 1}
}

for r_key, r_data in resources.items():
    m.addConstr(sum(r_data[f'x{i}'] * x[i] for i in range(len(variables))) <= r_data['upper_bound'], f'{r_data["description"]} constraint')


# Additional constraints
m.addConstr(5 * x[0] + 2 * x[2] >= 11)
m.addConstr(5 * x[0] + 4 * x[3] >= 13)
m.addConstr(7 * x[0] + 3 * x[3] >= 15)
m.addConstr(2 * x[2] + 3 * x[3] >= 8)
m.addConstr(7 * x[0] + 2 * x[2] + 2 * x[4] >= 12)
m.addConstr(2 * x[2] + 3 * x[3] + 2 * x[4] >= 12)
m.addConstr(7 * x[0] + 2 * x[2] + 3 * x[3] >= 12)
m.addConstr(7 * x[0] + 2 * x[2] + 2 * x[4] >= 14)
m.addConstr(2 * x[2] + 3 * x[3] + 2 * x[4] >= 14)
m.addConstr(7 * x[0] + 2 * x[2] + 3 * x[3] >= 14)
m.addConstr(7 * x[0] + 2 * x[2] + 2 * x[4] >= 17)
m.addConstr(2 * x[2] + 3 * x[3] + 2 * x[4] >= 17)
m.addConstr(7 * x[0] + 2 * x[2] + 3 * x[3] >= 17)
m.addConstr(2 * x[1] + 1 * x[3] >= 16)
m.addConstr(2 * x[1] + 8 * x[4] >= 16)
m.addConstr(8 * x[0] + 2 * x[1] >= 7)
m.addConstr(8 * x[0] + 8 * x[4] >= 12)
m.addConstr(7 * x[2] + 1 * x[3] >= 5)
m.addConstr(7 * x[2] + 8 * x[4] >= 6)
m.addConstr(8 * x[0] + 7 * x[2] >= 12)
m.addConstr(3 * x[2] + 1 * x[4] >= 14)
m.addConstr(1 * x[0] + 7 * x[1] + 5 * x[3] >= 18)

# ... (rest of the constraints)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
    print(f'Obj: {m.objVal}')
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

