
from gurobi import *

# Create a new model
m = Model()

# Define the variables
milligrams_vitamin_B2 = m.addVar(lb=0, name="milligrams_vitamin_B2", vtype=GRB.CONTINUOUS)
milligrams_vitamin_D = m.addVar(lb=0, name="milligrams_vitamin_D", vtype=GRB.CONTINUOUS)
milligrams_vitamin_C = m.addVar(lb=0, name="milligrams_vitamin_C", vtype=GRB.CONTINUOUS)
milligrams_vitamin_B5 = m.addVar(lb=0, name="milligrams_vitamin_B5", vtype=GRB.CONTINUOUS)
milligrams_vitamin_B9 = m.addVar(lb=0, name="milligrams_vitamin_B9", vtype=GRB.CONTINUOUS)
grams_fat = m.addVar(lb=0, name="grams_fat", vtype=GRB.CONTINUOUS)

# Define the objective function
m.setObjective(7.93 * milligrams_vitamin_B2 + 9.93 * milligrams_vitamin_D + 2.02 * milligrams_vitamin_C + 
               5.41 * milligrams_vitamin_B5 + 9.32 * milligrams_vitamin_B9 + 1.66 * grams_fat, GRB.MINIMIZE)

# Add constraints
# Energy stability index constraints
m.addConstr(29.87 * milligrams_vitamin_B2 + 18.52 * milligrams_vitamin_D + 15.79 * milligrams_vitamin_C + 
             20.84 * milligrams_vitamin_B5 + 29.02 * milligrams_vitamin_B9 + 22.58 * grams_fat >= 94)
m.addConstr(15.79 * milligrams_vitamin_C + 20.84 * milligrams_vitamin_B5 >= 54)
m.addConstr(29.87 * milligrams_vitamin_B2 + 18.52 * milligrams_vitamin_D >= 133)
m.addConstr(15.79 * milligrams_vitamin_C + 29.02 * milligrams_vitamin_B9 >= 114)
m.addConstr(18.52 * milligrams_vitamin_D + 15.79 * milligrams_vitamin_C >= 111)
m.addConstr(15.79 * milligrams_vitamin_C + 20.84 * milligrams_vitamin_B5 + 29.02 * milligrams_vitamin_B9 >= 127)
m.addConstr(29.87 * milligrams_vitamin_B2 + 20.84 * milligrams_vitamin_B5 + 29.02 * milligrams_vitamin_B9 >= 127)
m.addConstr(29.87 * milligrams_vitamin_B2 + 15.79 * milligrams_vitamin_C + 29.02 * milligrams_vitamin_B9 >= 127)
m.addConstr(18.52 * milligrams_vitamin_D + 15.79 * milligrams_vitamin_C + 20.84 * milligrams_vitamin_B5 >= 127)
m.addConstr(29.87 * milligrams_vitamin_B2 + 20.84 * milligrams_vitamin_B5 + grams_fat >= 127)
m.addConstr(29.87 * milligrams_vitamin_B2 + 18.52 * milligrams_vitamin_D + 15.79 * milligrams_vitamin_C >= 127)
m.addConstr(29.87 * milligrams_vitamin_B2 + 18.52 * milligrams_vitamin_D + 20.84 * milligrams_vitamin_B5 >= 127)
m.addConstr(18.52 * milligrams_vitamin_D + 20.84 * milligrams_vitamin_B5 + grams_fat >= 127)
m.addConstr(15.79 * milligrams_vitamin_C + 29.02 * milligrams_vitamin_B9 + grams_fat >= 127)
m.addConstr(20.84 * milligrams_vitamin_B5 + 29.02 * milligrams_vitamin_B9 + grams_fat >= 127)
m.addConstr(15.79 * milligrams_vitamin_C + 20.84 * milligrams_vitamin_B5 + grams_fat >= 127)
m.addConstr(18.52 * milligrams_vitamin_D + 20.84 * milligrams_vitamin_B5 + 29.02 * milligrams_vitamin_B9 >= 127)
m.addConstr(29.87 * milligrams_vitamin_B2 + 15.79 * milligrams_vitamin_C + 20.84 * milligrams_vitamin_B5 >= 127)
m.addConstr(29.87 * milligrams_vitamin_B2 + 18.52 * milligrams_vitamin_D + grams_fat >= 127)
m.addConstr(29.87 * milligrams_vitamin_B2 + 18.52 * milligrams_vitamin_D + 29.02 * milligrams_vitamin_B9 >= 127)
m.addConstr(15.79 * milligrams_vitamin_C + 20.84 * milligrams_vitamin_B5 + 29.02 * milligrams_vitamin_B9 >= 73)
m.addConstr(29.87 * milligrams_vitamin_B2 + 20.84 * milligrams_vitamin_B5 + 29.02 * milligrams_vitamin_B9 >= 73)
m.addConstr(29.87 * milligrams_vitamin_B2 + 15.79 * milligrams_vitamin_C + 29.02 * milligrams_vitamin_B9 >= 73)
m.addConstr(18.52 * milligrams_vitamin_D + 15.79 * milligrams_vitamin_C + 20.84 * milligrams_vitamin_B5 >= 73)
m.addConstr(29.87 * milligrams_vitamin_B2 + 20.84 * milligrams_vitamin_B5 + grams_fat >= 73)
m.addConstr(29.87 * milligrams_vitamin_B2 + 18.52 * milligrams_vitamin_D + 15.79 * milligrams_vitamin_C >= 73)
m.addConstr(29.87 * milligrams_vitamin_B2 + 18.52 * milligrams_vitamin_D + 20.84 * milligrams_vitamin_B5 >= 73)
m.addConstr(18.52 * milligrams_vitamin_D + 20.84 * milligrams_vitamin_B5 + grams_fat >= 73)
m.addConstr(15.79 * milligrams_vitamin_C + 29.02 * milligrams_vitamin_B9 + grams_fat >= 73)
m.addConstr(20.84 * milligrams_vitamin_B5 + 29.02 * milligrams_vitamin_B9 + grams_fat >= 73)
m.addConstr(15.79 * milligrams_vitamin_C + 20.84 * milligrams_vitamin_B5 + grams_fat >= 73)
m.addConstr(18.52 * milligrams_vitamin_D + 20.84 * milligrams_vitamin_B5 + 29.02 * milligrams_vitamin_B9 >= 73)

# Cognitive performance index constraints
m.addConstr(14.75 * milligrams_vitamin_B2 + 32.77 * milligrams_vitamin_B5 <= 670)
m.addConstr(16.13 * milligrams_vitamin_D + 32.77 * milligrams_vitamin_B5 <= 709)
m.addConstr(14.75 * milligrams_vitamin_B2 + 9.32 * milligrams_vitamin_B9 <= 332)
m.addConstr(14.75 * milligrams_vitamin_B2 + 27.32 * milligrams_vitamin_C <= 571)
m.addConstr(27.32 * milligrams_vitamin_C + 5.43 * grams_fat <= 657)
m.addConstr(16.13 * milligrams_vitamin_D + 27.32 * milligrams_vitamin_C + 32.77 * milligrams_vitamin_B5 <= 204)
m.addConstr(16.13 * milligrams_vitamin_D + 30.28 * milligrams_vitamin_B9 + 5.43 * grams_fat <= 301)
m.addConstr(14.75 * milligrams_vitamin_B2 + 16.13 * milligrams_vitamin_D + 30.28 * milligrams_vitamin_B9 <= 190)
m.addConstr(14.75 * milligrams_vitamin_B2 + 32.77 * milligrams_vitamin_B5 + grams_fat <= 277)
m.addConstr(14.75 * milligrams_vitamin_B2 + 16.13 * milligrams_vitamin_D + 27.32 * milligrams_vitamin_C <= 481)
m.addConstr(16.13 * milligrams_vitamin_D + 32.77 * milligrams_vitamin_B5 + 30.28 * milligrams_vitamin_B9 <= 181)
m.addConstr(16.13 * milligrams_vitamin_D + 27.32 * milligrams_vitamin_C + 30.28 * milligrams_vitamin_B9 <= 433)
m.addConstr(14.75 * milligrams_vitamin_B2 + 16.13 * milligrams_vitamin_D + 32.77 * milligrams_vitamin_B5 <= 403)
m.addConstr(14.75 * milligrams_vitamin_B2 + 27.32 * milligrams_vitamin_C + grams_fat <= 670)
m.addConstr(14.75 * milligrams_vitamin_B2 + 16.13 * milligrams_vitamin_D + grams_fat <= 291)

# Other constraints
m.addConstr(4 * milligrams_vitamin_C - 6 * milligrams_vitamin_B5 >= 0)
m.addConstr(-9 * milligrams_vitamin_B5 + 8 * milligrams_vitamin_B9 >= 0)
m.addConstr(16.13 * milligrams_vitamin_D + 30.28 * milligrams_vitamin_B9 <= 242)

# Solve the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Milligrams of vitamin B2: ", milligrams_vitamin_B2.varValue)
    print("Milligrams of vitamin D: ", milligrams_vitamin_D.varValue)
    print("Milligrams of vitamin C: ", milligrams_vitamin_C.varValue)
    print("Milligrams of vitamin B5: ", milligrams_vitamin_B5.varValue)
    print("Milligrams of vitamin B9: ", milligrams_vitamin_B9.varValue)
    print("Grams of fat: ", grams_fat.varValue)
else:
    print("No optimal solution found")
