
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
oranges = m.addVar(lb=0, name="oranges")
pasta = m.addVar(lb=0, name="bowls_of_pasta")
cornichons = m.addVar(lb=0, name="cornichons")

# Set objective function
m.setObjective(5.56 * oranges + 8.24 * pasta + 7.5 * cornichons, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(1 * oranges + 4 * pasta + 2 * cornichons >= 32, "protein_constraint1")
m.addConstr(1 * oranges + 2 * cornichons >= 26, "protein_constraint2")
m.addConstr(1 * oranges + 4 * pasta + 2 * cornichons >= 26, "protein_constraint3")

m.addConstr(2 * pasta + 7 * cornichons >= 8, "carbohydrate_constraint1")
m.addConstr(5 * oranges + 2 * pasta >= 6, "carbohydrate_constraint2")
m.addConstr(5 * oranges + 2 * pasta + 7 * cornichons >= 6, "carbohydrate_constraint3")
m.addConstr(5 * oranges + 2 * pasta + 7 * cornichons <= 35, "carbohydrate_constraint4")


m.addConstr(1 * pasta + 8 * cornichons >= 40, "fat_constraint1")
m.addConstr(7 * oranges + 1 * pasta >= 35, "fat_constraint2")
m.addConstr(7 * oranges + 1 * pasta + 8 * cornichons >= 35, "fat_constraint3")

m.addConstr(-1 * oranges + 7 * pasta >= 0, "additional_constraint1")

# Resource constraints (from the provided context)
m.addConstr(1 * oranges + 4 * pasta + 2 * cornichons <= 116, "protein_limit")
m.addConstr(5 * oranges + 2 * pasta + 7 * cornichons <= 42, "carbohydrate_limit")
m.addConstr(7 * oranges + 1 * pasta + 8 * cornichons <= 149, "fat_limit")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    print('Solution:')
    print('Oranges:', oranges.x)
    print('Bowls of pasta:', pasta.x)
    print('Cornichons:', cornichons.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status:', m.status)

