
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
oranges = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="oranges")
bowls_of_pasta = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bowls_of_pasta")
cornichons = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cornichons")

# Objective function
m.setObjective(5.56 * oranges + 8.24 * bowls_of_pasta + 7.5 * cornichons, GRB.MINIMIZE)

# Constraints
m.addConstr(oranges * 1 + bowls_of_pasta * 4 >= 32, name="protein_oranges_bowls")
m.addConstr(oranges * 1 + cornichons * 2 >= 26, name="protein_oranges_cornichons")
m.addConstr(oranges * 1 + bowls_of_pasta * 4 + cornichons * 2 >= 26, name="protein_all")

m.addConstr(bowls_of_pasta * 2 + cornichons * 7 >= 8, name="carbs_bowls_cornichons")
m.addConstr(oranges * 5 + bowls_of_pasta * 2 >= 6, name="carbs_oranges_bowls")
m.addConstr(oranges * 5 + bowls_of_pasta * 2 + cornichons * 7 >= 6, name="carbs_all_lower")
m.addConstr(oranges * 5 + bowls_of_pasta * 2 + cornichons * 7 <= 35, name="carbs_all_upper")

m.addConstr(bowls_of_pasta * 1 + cornichons * 8 >= 40, name="fat_bowls_cornichons")
m.addConstr(oranges * 7 + bowls_of_pasta * 1 >= 35, name="fat_oranges_bowls")
m.addConstr(oranges * 7 + bowls_of_pasta * 1 + cornichons * 8 >= 35, name="fat_all")

m.addConstr(-oranges + 7 * bowls_of_pasta >= 0, name="additional_constraint")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Oranges: {oranges.x}")
    print(f"Bowls of Pasta: {bowls_of_pasta.x}")
    print(f"Cornichons: {cornichons.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found.")
