
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    oranges = model.addVar(lb=0, name="oranges", vtype=gurobi.GRB.CONTINUOUS)
    bowls_of_pasta = model.addVar(lb=0, name="bowls_of_pasta", vtype=gurobi.GRB.CONTINUOUS)
    cornichons = model.addVar(lb=0, name="cornichons", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(5.56 * oranges + 8.24 * bowls_of_pasta + 7.5 * cornichons, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(oranges + 4 * bowls_of_pasta + 2 * cornichons >= 32, name="protein_total")
    model.addConstr(oranges + 2 * cornichons >= 26, name="protein_oranges_cornichons")
    model.addConstr(2 * bowls_of_pasta + 7 * cornichons >= 8, name="carbohydrates_pasta_cornichons")
    model.addConstr(5 * oranges + 2 * bowls_of_pasta >= 6, name="carbohydrates_oranges_pasta")
    model.addConstr(5 * oranges + 2 * bowls_of_pasta + 7 * cornichons <= 42, name="carbohydrates_total")
    model.addConstr(7 * bowls_of_pasta + 8 * cornichons >= 40, name="fat_pasta_cornichons")
    model.addConstr(7 * oranges + 7 * bowls_of_pasta >= 35, name="fat_oranges_pasta")
    model.addConstr(-oranges + 7 * bowls_of_pasta >= 0, name="additional_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Oranges: {oranges.varValue}")
        print(f"Bowls of Pasta: {bowls_of_pasta.varValue}")
        print(f"Cornichons: {cornichons.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The problem is infeasible.")
    else:
        print("The problem has another status.")

solve_optimization_problem()
