
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
sashimi = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="sashimi")
kale_salads = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="kale_salads")
chicken_thighs = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken_thighs")
protein_bars = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="protein_bars")
hot_dogs = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hot_dogs")
bagged_salads = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bagged_salads")

# Objective function
m.setObjective(4.42*sashimi + 1.83*kale_salads + 7.55*chicken_thighs + 7.94*protein_bars + 5.31*hot_dogs + 9.47*bagged_salads, GRB.MINIMIZE)

# Constraints
m.addConstr(11*sashimi + 19*kale_salads + 9*chicken_thighs + 13*protein_bars + 3*hot_dogs + 3*bagged_salads <= 693, "cost_constraint")
m.addConstr(18*sashimi + 21*kale_salads + 17*chicken_thighs + 0*protein_bars + 6*hot_dogs + 0*bagged_salads <= 836, "sourness_constraint")

# Additional constraints
m.addConstr(kale_salads + chicken_thighs >= 45)
m.addConstr(sashimi - 2*kale_salads <= 10)
m.addConstr(8*sashimi - 5*kale_salads >= 0)
m.addConstr(-6*chicken_thighs + 3*bagged_salads >= 0)
m.addConstr(-8*sashimi + 5*kale_salads >= 0)
m.addConstr(minus_8_times_chicken_thighs_plus_six_times_hot_dogs := -8*chicken_thighs + 6*hot_dogs, GRB.CONTINUOUS)
m.addConstr(minus_8_times_chicken_thighs_plus_six_times_hot_dogs >= 0)

# Sourness constraints
m.addConstr(18*sashimi + 21*kale_salads + 17*chicken_thighs <= 836, "max_sourness")
m.addConstr(6*hot_dogs + 0*bagged_salads <= 412, "hot_dog_bagged_max_sourness")
m.addConstr((0*protein_bars) + (6*hot_dogs) <= 460, "protein_hot_dog_max_sourness")

# Optimize the model
m.optimize()
