
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
security_engineers = m.addVar(vtype=GRB.INTEGER, name="security_engineers")
automatic_alerts = m.addVar(vtype=GRB.INTEGER, name="automatic_alerts", lb=0)
patches_per_day = m.addVar(vtype=GRB.INTEGER, name="patches_per_day")

# Objective function
m.setObjective(3 * security_engineers**2 + 3 * security_engineers * patches_per_day +
               3 * automatic_alerts**2 + 3 * automatic_alerts * patches_per_day +
               2 * patches_per_day**2 + 6 * automatic_alerts, GRB.MINIMIZE)

# Constraints
m.addConstr(10 * security_engineers >= 10)  # Data confidentiality impact of security engineers
m.addConstr(23 * automatic_alerts >= 23 * automatic_alerts)  # Impact of automatic alerts
m.addConstr(patches_per_day >= patches_per_day)  # Each patch has an impact of 1

# Total combined data confidentiality impact constraints
m.addConstr(10 * security_engineers + 23 * automatic_alerts >= 21)
m.addConstr((10 * security_engineers)**2 + (patches_per_day)**2 >= 35)
m.addConstr(10 * security_engineers + 23 * automatic_alerts + patches_per_day >= 35)

# Additional constraint
m.addConstr(10 * security_engineers - patches_per_day >= 0)

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Security Engineers: {security_engineers.x}")
    print(f"Automatic Alerts: {automatic_alerts.x}")
    print(f"Patches per Day: {patches_per_day.x}")
else:
    print("No optimal solution found")
