
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
bobby_hours = model.addVar(lb=0, name="bobby_hours")
mary_hours = model.addVar(lb=0, name="mary_hours")

# Set objective function
model.setObjective(9.26 * bobby_hours**2 + 9.08 * bobby_hours * mary_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(0.12 * bobby_hours + 0.75 * mary_hours >= 28, "organization_score_min")
model.addConstr(0.34 * bobby_hours + 0.74 * mary_hours >= 22, "work_quality_min")
model.addConstr(-10 * bobby_hours + 6 * mary_hours >= 0, "constraint_1")
model.addConstr(0.12 * bobby_hours + 0.75 * mary_hours <= 73, "organization_score_max")
model.addConstr(0.34 * bobby_hours + 0.74 * mary_hours <= 109, "work_quality_max")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print('Optimal solution found')
    print(f"Bobby's hours: {bobby_hours.x}")
    print(f"Mary's hours: {mary_hours.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print(f"Optimization ended with status {model.status}")

