
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(name='hours_worked_by_Bobby', lb=0)  # Hours worked by Bobby
x1 = m.addVar(name='hours_worked_by_Mary', lb=0)   # Hours worked by Mary

# Objective function: minimize
m.setObjective(9.26 * x0**2 + 9.08 * x0 * x1, GRB.MINIMIZE)

# Constraints
# Organization score constraints
m.addConstr(0.12*x0 + 0.75*x1 >= 28, name='org_score_min')
m.addConstr(0.12*x0 + 0.75*x1 <= 73, name='org_score_max')

# Work quality rating constraints
m.addConstr(0.34*x0 + 0.74*x1 >= 22, name='work_quality_min')
m.addConstr(0.34*x0 + 0.74*x1 <= 109, name='work_quality_max')

# Additional linear constraint
m.addConstr(-10*x0 + 6*x1 >= 0, name='additional_constraint')

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Hours worked by Bobby: {x0.x}')
    print(f'Hours worked by Mary: {x1.x}')
else:
    print('No optimal solution found')
