
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="hours_worked_by_Bobby")
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="hours_worked_by_Mary")

    # Objective function
    model.setObjective(9.26 * x0**2 + 9.08 * x0 * x1, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(0.12 * x0 + 0.75 * x1 >= 28, name="organization_score_min")
    model.addConstr(0.34 * x0 + 0.74 * x1 >= 22, name="work_quality_rating_min")
    model.addConstr(-10 * x0 + 6 * x1 >= 0, name="hourly_constraint")
    model.addConstr(0.12 * x0 + 0.75 * x1 <= 73, name="organization_score_max")
    model.addConstr(0.34 * x0 + 0.74 * x1 <= 109, name="work_quality_rating_max")

    # Optimize the model
    model.optimize()

    # Print the status of the optimization
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Bobby: {x0.varValue}")
        print(f"Hours worked by Mary: {x1.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

optimization_problem()
