
import gurobi

def optimize_vitamins():
    model = gurobi.Model()

    # Define variables
    x_A = model.addVar(name="milligrams of vitamin A", lb=0)
    x_B6 = model.addVar(name="milligrams of vitamin B6", lb=0)
    x_Z = model.addVar(name="milligrams of zinc", lb=0)
    x_B1 = model.addVar(name="milligrams of vitamin B1", lb=0)
    x_D = model.addVar(name="milligrams of vitamin D", lb=0)

    # Objective function
    model.setObjective(2*x_A + 7*x_B6 + 5*x_Z + 7*x_B1 + 3*x_D, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4*x_A <= 253, name="vitamin_A_kidney_support")
    model.addConstr(4*x_B6 <= 253, name="vitamin_B6_kidney_support")
    model.addConstr(x_Z <= 253, name="zinc_kidney_support")
    model.addConstr(6*x_B1 <= 253, name="vitamin_B1_kidney_support")
    model.addConstr(6*x_D <= 253, name="vitamin_D_kidney_support")

    model.addConstr(6*x_B1 + 6*x_D >= 17, name="B1_D_kidney_support")
    model.addConstr(x_Z + 6*x_D >= 24, name="Z_D_kidney_support")
    model.addConstr(x_Z + 6*x_B1 >= 34, name="Z_B1_kidney_support")
    model.addConstr(4*x_B6 + x_Z + 6*x_D >= 31, name="B6_Z_D_kidney_support")
    model.addConstr(4*x_A + 4*x_B6 + 6*x_B1 >= 31, name="A_B6_B1_kidney_support")
    model.addConstr(4*x_A + x_Z + 6*x_B1 >= 31, name="A_Z_B1_kidney_support")
    model.addConstr(4*x_B6 + 6*x_B1 + 6*x_D >= 31, name="B6_B1_D_kidney_support")
    model.addConstr(4*x_A + x_Z + 6*x_D >= 31, name="A_Z_D_kidney_support")
    model.addConstr(4*x_A + 4*x_B6 + 6*x_D >= 31, name="A_B6_D_kidney_support")
    model.addConstr(x_Z + 6*x_B1 + 6*x_D >= 31, name="Z_B1_D_kidney_support")

    model.addConstr(4*x_B6 + x_Z + 6*x_D >= 33, name="B6_Z_D_kidney_support_33")
    model.addConstr(4*x_A + 4*x_B6 + 6*x_B1 >= 33, name="A_B6_B1_kidney_support_33")
    model.addConstr(4*x_A + x_Z + 6*x_B1 >= 33, name="A_Z_B1_kidney_support_33")
    model.addConstr(4*x_B6 + 6*x_B1 + 6*x_D >= 33, name="B6_B1_D_kidney_support_33")
    model.addConstr(4*x_A + x_Z + 6*x_D >= 33, name="A_Z_D_kidney_support_33")
    model.addConstr(4*x_A + 4*x_B6 + 6*x_D >= 33, name="A_B6_D_kidney_support_33")
    model.addConstr(x_Z + 6*x_B1 + 6*x_D >= 33, name="Z_B1_D_kidney_support_33")

    model.addConstr(4*x_B6 + x_Z + 6*x_D >= 48, name="B6_Z_D_kidney_support_48")
    model.addConstr(4*x_A + 4*x_B6 + 6*x_B1 >= 48, name="A_B6_B1_kidney_support_48")
    model.addConstr(4*x_A + x_Z + 6*x_B1 >= 48, name="A_Z_B1_kidney_support_48")
    model.addConstr(4*x_B6 + 6*x_B1 + 6*x_D >= 48, name="B6_B1_D_kidney_support_48")
    model.addConstr(4*x_A + x_Z + 6*x_D >= 48, name="A_Z_D_kidney_support_48")
    model.addConstr(4*x_A + 4*x_B6 + 6*x_D >= 48, name="A_B6_D_kidney_support_48")
    model.addConstr(x_Z + 6*x_B1 + 6*x_D >= 48, name="Z_B1_D_kidney_support_48")

    model.addConstr(4*x_B6 + x_Z <= 221, name="B6_Z_limit")
    model.addConstr(4*x_B6 + 6*x_D <= 55, name="B6_D_limit")
    model.addConstr(x_Z + 6*x_B1 <= 229, name="Z_B1_limit")
    model.addConstr(6*x_B1 + 6*x_D <= 98, name="B1_D_limit")
    model.addConstr(4*x_A + 4*x_B6 + 6*x_B1 <= 161, name="A_B6_B1_limit")
    model.addConstr(4*x_A + x_Z + 6*x_B1 <= 95, name="A_Z_B1_limit")
    model.addConstr(4*x_A + 4*x_B6 + x_Z <= 244, name="A_B6_Z_limit")
    model.addConstr(4*x_A + 4*x_B6 + x_Z + 6*x_B1 + 6*x_D <= 244, name="all_limit")

    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin A: {x_A.varValue}")
        print(f"Milligrams of vitamin B6: {x_B6.varValue}")
        print(f"Milligrams of zinc: {x_Z.varValue}")
        print(f"Milligrams of vitamin B1: {x_B1.varValue}")
        print(f"Milligrams of vitamin D: {x_D.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
