
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
carbohydrates = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="carbohydrates")
potassium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potassium")
vitamin_B9 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B9")
vitamin_B1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B1")
vitamin_E = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_E")

# Set objective function
m.setObjective(1.42 * carbohydrates + 9.1 * potassium + 8.22 * vitamin_B9 + 3.08 * vitamin_B1 + 2.28 * vitamin_E, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9 * vitamin_B9 + 6 * vitamin_B1 >= 40, "c1")
m.addConstr(7 * potassium + 6 * vitamin_B1 >= 16, "c2")
m.addConstr(7 * carbohydrates + 9 * vitamin_B9 >= 33, "c3")
m.addConstr(7 * carbohydrates + 7 * potassium + 7 * vitamin_E >= 41, "c4")
m.addConstr(7 * carbohydrates + 7 * potassium + 9 * vitamin_B9 + 6 * vitamin_B1 + 7 * vitamin_E >= 41, "c5")
m.addConstr(6 * vitamin_B9 - 6 * vitamin_B1 >= 0, "c6")
m.addConstr(5 * vitamin_B9 - 4 * vitamin_E >= 0, "c7")
m.addConstr(-3 * carbohydrates + 5 * potassium >= 0, "c8")
m.addConstr(7 * potassium + 9 * vitamin_B9 <= 54, "c9")
m.addConstr(7 * potassium + 6 * vitamin_B1 <= 56, "c10")
m.addConstr(7 * carbohydrates + 6 * vitamin_B1 <= 169, "c11")
m.addConstr(7 * potassium + 9 * vitamin_B9 + 6 * vitamin_B1 <= 125, "c12")
m.addConstr(7 * carbohydrates + 9 * vitamin_B9 + 6 * vitamin_B1 <= 205, "c13")
m.addConstr(7 * carbohydrates + 9 * vitamin_B9 + 7 * vitamin_E <= 122, "c14")
m.addConstr(9 * vitamin_B9 + 6 * vitamin_B1 + 7 * vitamin_E <= 215, "c15")
m.addConstr(7 * carbohydrates + 7 * potassium + 6 * vitamin_B1 <= 111, "c16")
m.addConstr(7 * carbohydrates + 7 * potassium + 7 * vitamin_E <= 158, "c17")
m.addConstr(7 * potassium + 6 * vitamin_B1 + 7 * vitamin_E <= 58, "c18")
m.addConstr(7 * potassium + 9 * vitamin_B9 + 7 * vitamin_E <= 197, "c19")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

