
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x0 = m.addVar(name="grams_of_carbohydrates", lb=-gp.GRB.INFINITY)
x1 = m.addVar(name="milligrams_of_potassium", lb=-gp.GRB.INFINITY)
x2 = m.addVar(name="milligrams_of_vitamin_B9", lb=-gp.GRB.INFINITY)
x3 = m.addVar(name="milligrams_of_vitamin_B1", lb=-gp.GRB.INFINITY)
x4 = m.addVar(name="milligrams_of_vitamin_E", lb=-gp.GRB.INFINITY)

# Objective function
m.setObjective(1.42*x0 + 9.1*x1 + 8.22*x2 + 3.08*x3 + 2.28*x4, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(7*x0 <= 221)
m.addConstr(7*x1 <= 221)
m.addConstr(9*x2 <= 221)
m.addConstr(6*x3 <= 221)
m.addConstr(7*x4 <= 221)

m.addConstr(9*x2 + 6*x3 >= 40)
m.addConstr(7*x1 + 6*x3 >= 16)
m.addConstr(7*x0 + 9*x2 >= 33)
m.addConstr(7*x0 + 7*x1 + 7*x4 >= 41)
m.addConstr(7*x0 + 7*x1 + 9*x2 + 6*x3 + 7*x4 >= 41)

m.addConstr(6*x2 - 6*x3 >= 0)
m.addConstr(5*x2 - 4*x4 >= 0)
m.addConstr(-3*x0 + 5*x1 >= 0)

m.addConstr(7*x1 + 9*x2 <= 54)
m.addConstr(7*x1 + 6*x3 <= 56)
m.addConstr(7*x0 + 6*x3 <= 169)
m.addConstr(7*x1 + 9*x2 + 6*x3 <= 125)
m.addConstr(7*x0 + 9*x2 + 6*x3 <= 205)
m.addConstr(7*x0 + 9*x2 + 7*x4 <= 122)
m.addConstr(9*x2 + 6*x3 + 7*x4 <= 215)
m.addConstr(7*x0 + 7*x1 + 6*x3 <= 111)
m.addConstr(7*x0 + 7*x1 + 7*x4 <= 158)
m.addConstr(7*x1 + 6*x3 + 7*x4 <= 58)
m.addConstr(7*x1 + 9*x2 + 7*x4 <= 197)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Grams of carbohydrates: ", x0.varValue)
    print("Milligrams of potassium: ", x1.varValue)
    print("Milligrams of vitamin B9: ", x2.varValue)
    print("Milligrams of vitamin B1: ", x3.varValue)
    print("Milligrams of vitamin E: ", x4.varValue)
else:
    print("The model is infeasible")
