
from gurobipy import Model, GRB

# Create a new model
model = Model("Work Hours Optimization")

# Create variables
paul_hours = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="paul_hours")
jean_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="jean_hours")
laura_hours = model.addVar(lb=0, vtype=GRB.INTEGER, name="laura_hours")

# Set objective function
model.setObjective(4 * paul_hours + 3 * jean_hours + 8 * laura_hours, GRB.MINIMIZE)

# Add constraints

# Individual attribute constraints (already incorporated in other constraints)
# model.addConstr(4.21 * paul_hours == 4.21 * paul_hours)  # Redundant
# model.addConstr(2.1 * paul_hours == 2.1 * paul_hours)    # Redundant
# model.addConstr(7.97 * jean_hours == 7.97 * jean_hours)  # Redundant
# model.addConstr(16.79 * jean_hours == 16.79 * jean_hours) # Redundant
# model.addConstr(10.3 * laura_hours == 10.3 * laura_hours) # Redundant
# model.addConstr(5.13 * laura_hours == 5.13 * laura_hours)  # Redundant


model.addConstr(7.97 * jean_hours + 10.3 * laura_hours >= 19, "c1")
model.addConstr(4.21 * paul_hours + 10.3 * laura_hours >= 28, "c2")
model.addConstr(4.21 * paul_hours + 7.97 * jean_hours + 10.3 * laura_hours >= 31, "c3")
# Constraint c4 is redundant with c3
# model.addConstr(4.21 * paul_hours + 7.97 * jean_hours + 10.3 * laura_hours >= 31, "c4")

model.addConstr(16.79 * jean_hours + 5.13 * laura_hours >= 61, "c5")
model.addConstr(2.1 * paul_hours + 5.13 * laura_hours >= 61, "c6")
model.addConstr(2.1 * paul_hours + 16.79 * jean_hours + 5.13 * laura_hours >= 32, "c7")
# Constraint c8 is redundant with c7
# model.addConstr(2.1 * paul_hours + 16.79 * jean_hours + 5.13 * laura_hours >= 32, "c8")


model.addConstr(-2 * paul_hours + laura_hours >= 0, "c9")
model.addConstr(4.21 * paul_hours + 10.3 * laura_hours <= 49, "c10")
model.addConstr(2.1 * paul_hours + 5.13 * laura_hours <= 113, "c11")
model.addConstr(2.1 * paul_hours + 16.79 * jean_hours <= 151, "c12")



# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Paul Hours: %g' % paul_hours.x)
    print('Jean Hours: %g' % jean_hours.x)
    print('Laura Hours: %g' % laura_hours.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % model.status)
