
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
hours_worked_by_Paul = m.addVar(name="hours_worked_by_Paul", lb=0)
hours_worked_by_Jean = m.addVar(name="hours_worked_by_Jean", lb=0, integrality=gurobi.GRB.INTEGER)
hours_worked_by_Laura = m.addVar(name="hours_worked_by_Laura", lb=0, integrality=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(4 * hours_worked_by_Paul + 3 * hours_worked_by_Jean + 8 * hours_worked_by_Laura, gurobi.GRB.MINIMIZE)

# Define the constraints
m.addConstr(4.21 * hours_worked_by_Paul <= 140, name="Paul_likelihood_to_quit_index")
m.addConstr(2.1 * hours_worked_by_Paul <= 189, name="Paul_productivity_rating")
m.addConstr(7.97 * hours_worked_by_Jean <= 140, name="Jean_likelihood_to_quit_index")
m.addConstr(16.79 * hours_worked_by_Jean <= 189, name="Jean_productivity_rating")
m.addConstr(10.3 * hours_worked_by_Laura <= 140, name="Laura_likelihood_to_quit_index")
m.addConstr(5.13 * hours_worked_by_Laura <= 189, name="Laura_productivity_rating")

m.addConstr(7.97 * hours_worked_by_Jean + 10.3 * hours_worked_by_Laura >= 19, name="Jean_Laura_likelihood_to_quit_index")
m.addConstr(4.21 * hours_worked_by_Paul + 10.3 * hours_worked_by_Laura >= 28, name="Paul_Laura_likelihood_to_quit_index")
m.addConstr(4.21 * hours_worked_by_Paul + 7.97 * hours_worked_by_Jean + 10.3 * hours_worked_by_Laura >= 31, name="total_likelihood_to_quit_index")
m.addConstr(4.21 * hours_worked_by_Paul + 7.97 * hours_worked_by_Jean + 10.3 * hours_worked_by_Laura >= 31, name="total_likelihood_to_quit_index_2")

m.addConstr(16.79 * hours_worked_by_Jean + 5.13 * hours_worked_by_Laura >= 61, name="Jean_Laura_productivity_rating")
m.addConstr(2.1 * hours_worked_by_Paul + 5.13 * hours_worked_by_Laura >= 61, name="Paul_Laura_productivity_rating")
m.addConstr(2.1 * hours_worked_by_Paul + 16.79 * hours_worked_by_Jean + 5.13 * hours_worked_by_Laura >= 32, name="total_productivity_rating")
m.addConstr(2.1 * hours_worked_by_Paul + 16.79 * hours_worked_by_Jean + 5.13 * hours_worked_by_Laura >= 32, name="total_productivity_rating_2")

m.addConstr(-2 * hours_worked_by_Paul + hours_worked_by_Laura >= 0, name="hours_worked_constraint")

m.addConstr(4.21 * hours_worked_by_Paul + 10.3 * hours_worked_by_Laura <= 49, name="Paul_Laura_likelihood_to_quit_index_upper_bound")
m.addConstr(2.1 * hours_worked_by_Paul + 5.13 * hours_worked_by_Laura <= 113, name="Paul_Laura_productivity_rating_upper_bound")
m.addConstr(2.1 * hours_worked_by_Paul + 16.79 * hours_worked_by_Jean <= 151, name="Paul_Jean_productivity_rating_upper_bound")

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Hours worked by Paul:", hours_worked_by_Paul.varValue)
    print("Hours worked by Jean:", hours_worked_by_Jean.varValue)
    print("Hours worked by Laura:", hours_worked_by_Laura.varValue)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found.")
