
from gurobipy import Model, GRB

# Create a new model
m = Model("work_optimization")

# Create variables
hank_hours = m.addVar(vtype=GRB.INTEGER, name="hank_hours")
dale_hours = m.addVar(vtype=GRB.CONTINUOUS, name="dale_hours")

# Set objective function
m.setObjective(6.54 * hank_hours + 6.17 * dale_hours, GRB.MAXIMIZE)

# Add constraints
m.addConstr(18 * hank_hours + 7 * dale_hours >= 57, "c1")
m.addConstr(8 * hank_hours + 16 * dale_hours >= 67, "c2")
m.addConstr(4 * hank_hours - dale_hours >= 0, "c3")
m.addConstr(18 * hank_hours + 7 * dale_hours <= 123, "c4")
m.addConstr(8 * hank_hours + 16 * dale_hours <= 70, "c5")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Hank's hours: {hank_hours.x}")
    print(f"  Dale's hours: {dale_hours.x}")
    print(f"  Objective value: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

