
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
H = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Hank")
D = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Dale")

# Objective function
m.setObjective(6.54*H + 6.17*D, GRB.MAXIMIZE)

# Constraints
m.addConstr(18*H + 7*D >= 57, "likelihood_to_quit_index_min")
m.addConstr(8*H + 16*D >= 67, "work_quality_rating_min")
m.addConstr(4*H - D >= 0, "hours_worked_constraint")
m.addConstr(18*H + 7*D <= 123, "likelihood_to_quit_index_max")
m.addConstr(8*H + 16*D <= 70, "work_quality_rating_max")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Hours worked by Hank:", H.x)
    print("Hours worked by Dale:", D.x)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found. Status:", m.status)

