
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    # Assuming x0 is hours worked by Hank and x1 is hours worked by Dale
    x0 = model.addVar(name="hours_worked_by_Hank", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="hours_worked_by_Dale")

    # Objective function
    model.setObjective(6.54 * x0 + 6.17 * x1, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Individual attributes are implicitly handled as they are constants
    # Combined constraints
    model.addConstr(18 * x0 + 7 * x1 >= 57, name="likelihood_to_quit_min")
    model.addConstr(8 * x0 + 16 * x1 >= 67, name="work_quality_rating_min")
    model.addConstr(4 * x0 - x1 >= 0, name="hank_dale_work_ratio")
    model.addConstr(18 * x0 + 7 * x1 <= 123, name="likelihood_to_quit_max")
    model.addConstr(8 * x0 + 16 * x1 <= 70, name="work_quality_rating_max")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Hours worked by Hank: {x0.varValue}")
        print(f"Hours worked by Dale: {x1.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
