
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Labor Cost")

# Create variables
dale_hours = model.addVar(vtype=GRB.INTEGER, name="dale_hours")
laura_hours = model.addVar(vtype=GRB.INTEGER, name="laura_hours")
paul_hours = model.addVar(vtype=GRB.INTEGER, name="paul_hours")

# Set objective function
model.setObjective(2 * dale_hours + 4 * laura_hours + 2 * paul_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(13 * dale_hours + 29 * laura_hours >= 107, "c1")
model.addConstr(13 * dale_hours + 29 * laura_hours + 20 * paul_hours >= 84, "c2")
model.addConstr(10 * dale_hours + 3 * laura_hours >= 76, "c3")
model.addConstr(10 * dale_hours + 25 * paul_hours >= 58, "c4")
model.addConstr(10 * dale_hours + 3 * laura_hours + 25 * paul_hours >= 58, "c5")
model.addConstr(laura_hours - 5 * paul_hours >= 0, "c6")
model.addConstr(13 * dale_hours + 29 * laura_hours <= 392, "c7")
model.addConstr(13 * dale_hours + 20 * paul_hours <= 343, "c8")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print('Optimal objective:', model.objVal)
    print('Dale hours:', dale_hours.x)
    print('Laura hours:', laura_hours.x)
    print('Paul hours:', paul_hours.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print(f"Optimization ended with status {model.status}")

