
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
hours_worked_by_Dale = model.addVar(name="hours_worked_by_Dale", vtype=gurobi.GRB.INTEGER)
hours_worked_by_Laura = model.addVar(name="hours_worked_by_Laura", vtype=gurobi.GRB.INTEGER)
hours_worked_by_Paul = model.addVar(name="hours_worked_by_Paul", vtype=gurobi.GRB.INTEGER)

# Objective function
model.setObjective(2 * hours_worked_by_Dale + 4 * hours_worked_by_Laura + 2 * hours_worked_by_Paul, gurobi.GRB.MINIMIZE)

# Constraints
# 1. Total dollar cost per hour from Dale and Laura >= 107
model.addConstr(13 * hours_worked_by_Dale + 29 * hours_worked_by_Laura >= 107)

# 2. & 3. Total dollar cost per hour from all >= 84 (redundant with 1 and others)
model.addConstr(13 * hours_worked_by_Dale + 29 * hours_worked_by_Laura + 20 * hours_worked_by_Paul >= 84)

# 4. & 5. Organization score from Dale and Laura >= 76
model.addConstr(10 * hours_worked_by_Dale + 3 * hours_worked_by_Laura >= 76)

# 6. Organization score from Dale and Paul >= 58
model.addConstr(10 * hours_worked_by_Dale + 25 * hours_worked_by_Paul >= 58)

# 7. Organization score from all >= 58
model.addConstr(10 * hours_worked_by_Dale + 3 * hours_worked_by_Laura + 25 * hours_worked_by_Paul >= 58)

# 8. Laura and Paul constraint
model.addConstr(hours_worked_by_Laura - 5 * hours_worked_by_Paul >= 0)

# 9. Dollar cost from Dale and Laura <= 392
model.addConstr(13 * hours_worked_by_Dale + 29 * hours_worked_by_Laura <= 392)

# 10. Dollar cost from Dale and Paul <= 343
model.addConstr(13 * hours_worked_by_Dale + 20 * hours_worked_by_Paul <= 343)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by Dale: {hours_worked_by_Dale.varValue}")
    print(f"Hours worked by Laura: {hours_worked_by_Laura.varValue}")
    print(f"Hours worked by Paul: {hours_worked_by_Paul.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
