
from gurobipy import Model, GRB

# Create a new model
model = Model("nutrition_optimization")

# Create variables
fat = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="fat")
b2 = model.addVar(lb=0, vtype=GRB.INTEGER, name="b2")
b3 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="b3")

# Set objective function
model.setObjective(9 * fat + 4 * b2 + 2 * b3, GRB.MINIMIZE)

# Add constraints
model.addConstr(3.84 * fat + 5.67 * b3 >= 19, "c1")
model.addConstr(3.84 * fat + 4.56 * b2 >= 16, "c2")
model.addConstr(3.84 * fat + 4.56 * b2 + 5.67 * b3 >= 16, "c3")
model.addConstr(3 * b2 - 2 * b3 >= 0, "c4")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print('Optimal objective value:', model.objVal)
    print('Fat:', fat.x)
    print('Vitamin B2:', b2.x)
    print('Vitamin B3:', b3.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status:', model.status)

