
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="grams_of_fat")
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="milligrams_of_vitamin_B2")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B3")

# Objective function
m.setObjective(9*x0 + 4*x1 + 2*x2, GRB.MINIMIZE)

# Constraints
m.addConstr(3.84*x0 + 5.67*x2 >= 19, "cardiovascular_support_index_1")
m.addConstr(3.84*x0 + 4.56*x1 >= 16, "cardiovascular_support_index_2")
m.addConstr(3.84*x0 + 4.56*x1 + 5.67*x2 >= 16, "total_cardiovascular_support_index")
m.addConstr(3*x1 - 2*x2 >= 0, "vitamin_b2_and_b3_relationship")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"grams_of_fat: {x0.x}")
    print(f"milligrams_of_vitamin_B2: {x1.x}")
    print(f"milligrams_of_vitamin_B3: {x2.x}")
else:
    print("No optimal solution found")
