
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("plant_optimization")

    # Create variables
    verbenas = m.addVar(vtype=gp.GRB.INTEGER, name="verbenas")
    agave = m.addVar(vtype=gp.GRB.INTEGER, name="agave")
    peonies = m.addVar(vtype=gp.GRB.INTEGER, name="peonies")
    geraniums = m.addVar(vtype=gp.GRB.INTEGER, name="geraniums")

    # Set objective function
    m.setObjective(3.32 * verbenas + 8.56 * agave + 3.32 * peonies + 8.22 * geraniums, gp.GRB.MAXIMIZE)

    # Add constraints (converting sq ft to sq in where necessary)
    m.addConstr(26 * verbenas + 11 * agave + 20 * peonies + 9 * geraniums <= 193, "Planting Space")
    m.addConstr(20 * verbenas + 5 * agave + 11 * peonies + 11 * geraniums <= 257, "Resilience Index")
    m.addConstr(20 * peonies + 9 * geraniums >= 33 * 144, "Peonies + Geraniums Space") # 33 sq ft
    m.addConstr(26 * verbenas + 9 * geraniums >= 28 * 144, "Verbenas + Geraniums Space") # 28 sq ft
    m.addConstr(20 * verbenas + 11 * geraniums >= 28, "Verbenas + Geraniums Resilience")
    m.addConstr(20 * verbenas + 5 * agave + 11 * peonies >= 42, "Verbenas + Agave + Peonies Resilience")
    m.addConstr(20 * verbenas + 11 * peonies + 11 * geraniums >= 42, "Verbenas + Peonies + Geraniums Resilience")
    m.addConstr(20 * verbenas + 5 * agave + 11 * peonies >= 55, "Verbenas + Agave + Peonies Resilience 2")
    m.addConstr(20 * verbenas + 11 * peonies + 11 * geraniums >= 55, "Verbenas + Peonies + Geraniums Resilience 2")
    m.addConstr(11 * agave + 9 * geraniums <= 168 * 144, "Agave + Geraniums Space") # 168 sq ft
    m.addConstr(26 * verbenas + 11 * agave + 20 * peonies + 9 * geraniums <= 168 * 144, "Total Space") # 168 sq ft
    m.addConstr(5 * agave + 11 * peonies <= 175, "Agave + Peonies Resilience")
    m.addConstr(20 * verbenas + 11 * peonies <= 95, "Verbenas + Peonies Resilience")
    m.addConstr(20 * verbenas + 11 * geraniums <= 117, "Verbenas + Geraniums Resilience Limit")
    m.addConstr(5 * agave + 11 * geraniums <= 210, "Agave + Geraniums Resilience")
    m.addConstr(20 * verbenas + 5 * agave + 11 * peonies + 11 * geraniums <= 210, "Total Resilience")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
