
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
verbenas = m.addVar(vtype=gurobi.GRB.INTEGER, name="verbenas")
agave = m.addVar(vtype=gurobi.GRB.INTEGER, name="agave")
peonies = m.addVar(vtype=gurobi.GRB.INTEGER, name="peonies")
geraniums = m.addVar(vtype=gurobi.GRB.INTEGER, name="geraniums")

# Objective function
m.setObjective(3.32 * verbenas + 8.56 * agave + 3.32 * peonies + 8.22 * geraniums, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(26 * verbenas + 11 * agave + 20 * peonies + 9 * geraniums <= 193, "planting_space")
m.addConstr(20 * verbenas + 5 * agave + 11 * peonies + 11 * geraniums <= 257, "resilience_index")
m.addConstr(peonies + geraniums >= 33, "peonies_geraniums_space")
m.addConstr(26 * verbenas + 9 * geraniums >= 28 * 144 / 144, "verbenas_geraniums_space")
m.addConstr(20 * verbenas + 11 * geraniums >= 28, "verbenas_geraniums_resilience")
m.addConstr(20 * verbenas + 11 * peonies + 11 * geraniums >= 42, "verbenas_peonies_geraniums_resilience")
m.addConstr(20 * verbenas + 5 * agave + 11 * peonies >= 55, "verbenas_agave_peonies_resilience")
m.addConstr(11 * agave + 9 * geraniums <= 168, "agave_geraniums_space")
m.addConstr(26 * verbenas + 11 * agave + 20 * peonies + 9 * geraniums <= 168 * 144 / 144, "total_space")
m.addConstr(5 * agave + 11 * peonies <= 175, "agave_peonies_resilience")
m.addConstr(20 * verbenas + 11 * peonies <= 95, "verbenas_peonies_resilience")
m.addConstr(20 * verbenas + 11 * geraniums <= 117, "verbenas_geraniums_resilience_max")
m.addConstr(5 * agave + 11 * geraniums <= 210, "agave_geraniums_resilience_max")
m.addConstr(20 * verbenas + 5 * agave + 11 * peonies + 11 * geraniums <= 210, "total_resilience")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Verbenas: {verbenas.varValue}")
    print(f"Agave: {agave.varValue}")
    print(f"Peonies: {peonies.varValue}")
    print(f"Geraniums: {geraniums.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
