
from gurobipy import Model, GRB

# Create a new model
m = Model("food_optimization")

# Create variables
rotisserie_chickens = m.addVar(vtype=GRB.INTEGER, name="rotisserie_chickens")
steaks = m.addVar(vtype=GRB.CONTINUOUS, name="steaks")

# Set objective function
m.setObjective(4 * rotisserie_chickens + 9 * steaks, GRB.MINIMIZE)

# Add constraints
m.addConstr(22 * rotisserie_chickens + 14 * steaks >= 77, "healthiness_min")
m.addConstr(22 * rotisserie_chickens + 14 * steaks <= 174, "healthiness_max")
m.addConstr(8 * rotisserie_chickens + 4 * steaks >= 75, "calcium_min")
m.addConstr(8 * rotisserie_chickens + 4 * steaks <= 218, "calcium_max")
m.addConstr(26 * rotisserie_chickens + 20 * steaks >= 43, "fat_min")
m.addConstr(26 * rotisserie_chickens + 20 * steaks <= 64, "fat_max")
m.addConstr(1 * rotisserie_chickens - 5 * steaks >= 0, "additional_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Rotisserie Chickens: %g' % rotisserie_chickens.x)
    print('Steaks: %g' % steaks.x)
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

