
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="rotisserie_chickens")  # Integer variable for rotisserie chickens
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="steaks")  # Continuous variable for steaks

# Set objective function: Minimize 4*x0 + 9*x1
m.setObjective(4*x0 + 9*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(22*x0 + 14*x1 >= 77, name="min_healthiness")
m.addConstr(22*x0 + 14*x1 <= 174, name="max_healthiness")
m.addConstr(8*x0 + 4*x1 >= 75, name="min_calcium")
m.addConstr(8*x0 + 4*x1 <= 218, name="max_calcium")
m.addConstr(26*x0 + 20*x1 >= 43, name="min_fat")
m.addConstr(26*x0 + 20*x1 <= 64, name="max_fat")
m.addConstr(x0 - 5*x1 >= 0, name="additional_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of rotisserie chickens: {x0.x}")
    print(f"Number of steaks: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
