
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    rotisserie_chickens = model.addVar(name="rotisserie_chickens", integer=True)
    steaks = model.addVar(name="steaks")

    # Objective function: Minimize 4 * rotisserie_chickens + 9 * steaks
    model.setObjective(4 * rotisserie_chickens + 9 * steaks, gurobi.GRB.MINIMIZE)

    # Constraints
    # Healthiness rating at least 77
    model.addConstraint(22 * rotisserie_chickens + 14 * steaks >= 77)

    # Calcium at least 75 milligrams
    model.addConstraint(8 * rotisserie_chickens + 4 * steaks >= 75)

    # Fat at least 43 grams
    model.addConstraint(26 * rotisserie_chickens + 20 * steaks >= 43)

    # Healthiness rating at most 174
    model.addConstraint(22 * rotisserie_chickens + 14 * steaks <= 174)

    # Calcium at most 218 milligrams
    model.addConstraint(8 * rotisserie_chickens + 4 * steaks <= 218)

    # Fat at most 64 grams
    model.addConstraint(26 * rotisserie_chickens + 20 * steaks <= 64)

    # Additional constraint: 1 * rotisserie_chickens - 5 * steaks >= 0
    model.addConstraint(rotisserie_chickens - 5 * steaks >= 0)

    # Solve the model
    model.optimize()

    # Print the status of the optimization
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Rotisserie Chickens: {rotisserie_chickens.varValue}")
        print(f"Steaks: {steaks.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

optimization_problem()
