
import gurobipy as gp

# Create a new model
m = gp.Model("WorkOptimization")

# Create variables
mary_hours = m.addVar(name="mary_hours")
jean_hours = m.addVar(name="jean_hours")
george_hours = m.addVar(name="george_hours")

# Set objective function
m.setObjective(1.7 * mary_hours + 9.18 * jean_hours + 6.03 * george_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(16 * mary_hours + 13 * jean_hours >= 36, "c1")
m.addConstr(13 * jean_hours + 5 * george_hours >= 16, "c2")
m.addConstr(16 * mary_hours + 13 * jean_hours + 5 * george_hours >= 21, "c3")
m.addConstr(11 * jean_hours + 16 * george_hours >= 19, "c4")
m.addConstr(11 * mary_hours + 16 * george_hours >= 21, "c5")
m.addConstr(11 * mary_hours + 7 * jean_hours + 16 * george_hours >= 21, "c6")
m.addConstr(1 * mary_hours + 7 * george_hours >= 24, "c7")
m.addConstr(1 * mary_hours + 6 * jean_hours >= 47, "c8")
m.addConstr(6 * jean_hours + 7 * george_hours >= 43, "c9")
m.addConstr(1 * mary_hours + 6 * jean_hours + 7 * george_hours >= 43, "c10")
m.addConstr(16 * mary_hours + 5 * george_hours <= 107, "c11")
m.addConstr(16 * mary_hours + 13 * jean_hours + 5 * george_hours <= 108, "c12")
m.addConstr(11 * mary_hours + 16 * george_hours <= 40, "c13")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective: %g' % m.objVal)
    print('Mary hours:', mary_hours.x)
    print('Jean hours:', jean_hours.x)
    print('George hours:', george_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

