
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
hours_worked_by_Mary = m.addVar(name="hours_worked_by_Mary", lb=0)  # No upper bound given
hours_worked_by_Jean = m.addVar(name="hours_worked_by_Jean", lb=0)  # No upper bound given
hours_worked_by_George = m.addVar(name="hours_worked_by_George", lb=0)  # No upper bound given

# Objective function: Minimize 1.7 * hours_worked_by_Mary + 9.18 * hours_worked_by_Jean + 6.03 * hours_worked_by_George
m.setObjective(1.7 * hours_worked_by_Mary + 9.18 * hours_worked_by_Jean + 6.03 * hours_worked_by_George, gp.GRB.MINIMIZE)

# Constraints
# Individual ratings
m.addConstr(hours_worked_by_Mary * 16 <= 121, "Mary_work_quality_rating")
m.addConstr(hours_worked_by_Mary * 11 <= 107, "Mary_productivity_rating")
m.addConstr(hours_worked_by_Mary * 1 <= 166, "Mary_organization_score")

m.addConstr(hours_worked_by_Jean * 13 <= 121, "Jean_work_quality_rating")
m.addConstr(hours_worked_by_Jean * 7 <= 107, "Jean_productivity_rating")
m.addConstr(hours_worked_by_Jean * 6 <= 166, "Jean_organization_score")

m.addConstr(hours_worked_by_George * 5 <= 121, "George_work_quality_rating")
m.addConstr(hours_worked_by_George * 16 <= 107, "George_productivity_rating")
m.addConstr(hours_worked_by_George * 7 <= 166, "George_organization_score")

# Combined ratings
m.addConstr(hours_worked_by_Mary * 16 + hours_worked_by_Jean * 13 >= 36, "Combined_work_quality_rating_Mary_Jean")
m.addConstr(hours_worked_by_Jean * 13 + hours_worked_by_George * 5 >= 16, "Combined_work_quality_rating_Jean_George")
m.addConstr(hours_worked_by_Mary * 16 + hours_worked_by_Jean * 13 + hours_worked_by_George * 5 >= 21, "Combined_work_quality_rating_all")

m.addConstr(hours_worked_by_Jean * 7 + hours_worked_by_George * 16 >= 19, "Combined_productivity_rating_Jean_George")
m.addConstr(hours_worked_by_Mary * 11 + hours_worked_by_George * 16 >= 21, "Combined_productivity_rating_Mary_George")
m.addConstr(hours_worked_by_Mary * 11 + hours_worked_by_Jean * 7 + hours_worked_by_George * 16 >= 21, "Combined_productivity_rating_all")

m.addConstr(hours_worked_by_Mary * 1 + hours_worked_by_George * 7 >= 24, "Combined_organization_score_Mary_George")
m.addConstr(hours_worked_by_Mary * 1 + hours_worked_by_Jean * 6 >= 47, "Combined_organization_score_Mary_Jean")
m.addConstr(hours_worked_by_Jean * 6 + hours_worked_by_George * 7 >= 43, "Combined_organization_score_Jean_George")
m.addConstr(hours_worked_by_Mary * 1 + hours_worked_by_Jean * 6 + hours_worked_by_George * 7 >= 43, "Combined_organization_score_all")

m.addConstr(hours_worked_by_Mary * 16 + hours_worked_by_George * 5 <= 107, "Combined_work_quality_rating_Mary_George")
m.addConstr(hours_worked_by_Mary * 16 + hours_worked_by_Jean * 13 + hours_worked_by_George * 5 <= 108, "Combined_work_quality_rating_all")

m.addConstr(hours_worked_by_Mary * 11 + hours_worked_by_George * 16 <= 40, "Combined_productivity_rating_Mary_George")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by Mary: {hours_worked_by_Mary.varValue}")
    print(f"Hours worked by Jean: {hours_worked_by_Jean.varValue}")
    print(f"Hours worked by George: {hours_worked_by_George.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found")
