
import gurobipy as gp

# Create a new model
m = gp.Model("minimize_cost")

# Create variables
george_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george_hours")
bill_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill_hours")
hank_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank_hours")

# Set objective function
m.setObjective(9 * george_hours + 5 * bill_hours + 9 * hank_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(1 * george_hours + 4 * hank_hours >= 19, "c1")
m.addConstr(1 * george_hours + 3 * bill_hours >= 24, "c2")
m.addConstr(1 * george_hours + 3 * bill_hours + 4 * hank_hours >= 24, "c3")
m.addConstr(3 * george_hours + 1 * hank_hours >= 14, "c4")
m.addConstr(3 * george_hours + 4 * bill_hours >= 6, "c5")
m.addConstr(4 * bill_hours + 1 * hank_hours >= 6, "c6")
m.addConstr(3 * george_hours + 4 * bill_hours + 1 * hank_hours >= 6, "c7")
m.addConstr(-8 * bill_hours + 3 * hank_hours >= 0, "c8")
m.addConstr(1 * george_hours + 4 * hank_hours <= 39, "c9")
m.addConstr(3 * george_hours + 1 * hank_hours <= 53, "c10")
m.addConstr(3 * george_hours + 4 * bill_hours + 1 * hank_hours <= 38, "c11")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective: %g' % m.objVal)
    print('George hours: %g' % george_hours.x)
    print('Bill hours: %g' % bill_hours.x)
    print('Hank hours: %g' % hank_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

