
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
G = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_George")
B = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Bill")
H = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Hank")

# Objective function
m.setObjective(9*G + 5*B + 9*H, GRB.MINIMIZE)

# Constraints
m.addConstr(G + H >= 19, "likelihood_to_quit_GH")
m.addConstr(G + B >= 24, "likelihood_to_quit_GB")
m.addConstr(G + B + H >= 24, "likelihood_to_quit_GBH")

m.addConstr(3*G + H >= 14, "dollar_cost_GH") # Assuming this reflects the intention behind the problem statement
m.addConstr(3*G + 4*B >= 6, "dollar_cost_GB")
m.addConstr(4*B + H >= 6, "dollar_cost_BH")
m.addConstr(3*G + 4*B + H >= 6, "dollar_cost_GBH")

m.addConstr(-8*B + 3*H >= 0, "additional_constraint_1")
m.addConstr(G + H <= 39, "likelihood_to_quit_GH_upper_bound")
m.addConstr(3*G + H <= 53, "dollar_cost_GH_upper_bound") # Corrected based on provided coefficients and problem context
m.addConstr(3*G + 4*B + H <= 38, "dollar_cost_GBH_upper_bound")

# Optimize model
m.optimize()

# Print results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print(f"Objective: {m.objVal}")
