
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
hours_george = m.addVar(name="hours_george", lb=0)
hours_bill = m.addVar(name="hours_bill", lb=0)
hours_hank = m.addVar(name="hours_hank", lb=0)

# Define the objective function
m.setObjective(9 * hours_george + 5 * hours_bill + 9 * hours_hank, gurobi.GRB.MINIMIZE)

# Define the constraints
m.addConstr(1 * hours_george + 4 * hours_hank >= 19)
m.addConstr(1 * hours_george + 3 * hours_bill >= 24)
m.addConstr(1 * hours_george + 3 * hours_bill + 4 * hours_hank >= 24)
m.addConstr(3 * hours_george + 1 * hours_hank >= 14)
m.addConstr(3 * hours_george + 4 * hours_bill >= 6)
m.addConstr(4 * hours_bill + 1 * hours_hank >= 6)
m.addConstr(3 * hours_george + 4 * hours_bill + 1 * hours_hank >= 6)
m.addConstr(-8 * hours_bill + 3 * hours_hank >= 0)
m.addConstr(1 * hours_george + 4 * hours_hank <= 39)
m.addConstr(3 * hours_george + 1 * hours_hank <= 53)
m.addConstr(3 * hours_george + 4 * hours_bill + 1 * hours_hank <= 38)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by George: {hours_george.varValue}")
    print(f"Hours worked by Bill: {hours_bill.varValue}")
    print(f"Hours worked by Hank: {hours_hank.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
