
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
lightbulbs = m.addVar(vtype=gp.GRB.INTEGER, name="lightbulbs")
napkins = m.addVar(vtype=gp.GRB.INTEGER, name="napkins")
dish_soap = m.addVar(vtype=gp.GRB.INTEGER, name="dish_soap")
cookies = m.addVar(vtype=gp.GRB.INTEGER, name="cookies")

# Set objective function
m.setObjective(5 * lightbulbs + 2 * napkins + 9 * dish_soap + 9 * cookies, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(6.79 * lightbulbs + 11.82 * dish_soap + 9.22 * cookies >= 106)
m.addConstr(6.79 * lightbulbs + 6.59 * napkins + 9.22 * cookies >= 106)
m.addConstr(6.79 * lightbulbs + 6.59 * napkins + 11.82 * dish_soap >= 106)
m.addConstr(6.79 * lightbulbs + 11.82 * dish_soap + 9.22 * cookies >= 79)
m.addConstr(6.79 * lightbulbs + 6.59 * napkins + 9.22 * cookies >= 79)
m.addConstr(6.79 * lightbulbs + 6.59 * napkins + 11.82 * dish_soap >= 79)
m.addConstr(6.79 * lightbulbs + 11.82 * dish_soap + 9.22 * cookies >= 145)
m.addConstr(6.79 * lightbulbs + 6.59 * napkins + 9.22 * cookies >= 145)
m.addConstr(6.79 * lightbulbs + 6.59 * napkins + 11.82 * dish_soap >= 145)

m.addConstr(14.05 * lightbulbs + 11.8 * napkins <= 144)
m.addConstr(14.05 * lightbulbs + 14.52 * dish_soap <= 104)
m.addConstr(11.8 * napkins + 0.93 * cookies <= 238)
m.addConstr(14.52 * dish_soap + 0.93 * cookies <= 260)
m.addConstr(14.05 * lightbulbs + 11.8 * napkins + 14.52 * dish_soap <= 195)
m.addConstr(14.05 * lightbulbs + 11.8 * napkins + 14.52 * dish_soap + 0.93 * cookies <= 195)

m.addConstr(6.79 * lightbulbs + 6.59 * napkins <= 458)
m.addConstr(6.79 * lightbulbs + 9.22 * cookies <= 521)
m.addConstr(6.79 * lightbulbs + 11.82 * dish_soap <= 505)
m.addConstr(6.79 * lightbulbs + 6.59 * napkins + 11.82 * dish_soap + 9.22 * cookies <= 505)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

