
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
lightbulbs = m.addVar(name="lightbulbs", vtype=gp.GRB.INTEGER)
packs_of_napkins = m.addVar(name="packs_of_napkins", vtype=gp.GRB.INTEGER)
dish_soap_bottles = m.addVar(name="dish_soap_bottles", vtype=gp.GRB.INTEGER)
cookies = m.addVar(name="cookies", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(5 * lightbulbs + 2 * packs_of_napkins + 9 * dish_soap_bottles + 9 * cookies, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14.05 * lightbulbs + 11.8 * packs_of_napkins <= 280, name="portability_rating_1")
m.addConstr(14.05 * lightbulbs + 14.52 * dish_soap_bottles <= 104, name="portability_rating_2")
m.addConstr(11.8 * packs_of_napkins + 0.93 * cookies <= 238, name="portability_rating_3")
m.addConstr(14.52 * dish_soap_bottles + 0.93 * cookies <= 260, name="portability_rating_4")
m.addConstr(14.05 * lightbulbs + 11.8 * packs_of_napkins + 14.52 * dish_soap_bottles <= 195, name="portability_rating_5")
m.addConstr(14.05 * lightbulbs + 11.8 * packs_of_napkins + 14.52 * dish_soap_bottles + 0.93 * cookies <= 195, name="portability_rating_6")

m.addConstr(6.79 * lightbulbs + 11.82 * dish_soap_bottles + 9.22 * cookies >= 106, name="sustainability_score_1")
m.addConstr(6.79 * lightbulbs + 6.59 * packs_of_napkins + 9.22 * cookies >= 106, name="sustainability_score_2")
m.addConstr(6.79 * lightbulbs + 6.59 * packs_of_napkins + 11.82 * dish_soap_bottles >= 106, name="sustainability_score_3")
m.addConstr(6.79 * lightbulbs + 11.82 * dish_soap_bottles + 9.22 * cookies >= 79, name="sustainability_score_4")
m.addConstr(6.79 * lightbulbs + 6.59 * packs_of_napkins + 9.22 * cookies >= 79, name="sustainability_score_5")
m.addConstr(6.79 * lightbulbs + 6.59 * packs_of_napkins + 11.82 * dish_soap_bottles >= 79, name="sustainability_score_6")
m.addConstr(6.79 * lightbulbs + 11.82 * dish_soap_bottles + 9.22 * cookies >= 145, name="sustainability_score_7")
m.addConstr(6.79 * lightbulbs + 6.59 * packs_of_napkins + 9.22 * cookies >= 145, name="sustainability_score_8")
m.addConstr(6.79 * lightbulbs + 6.59 * packs_of_napkins + 11.82 * dish_soap_bottles >= 145, name="sustainability_score_9")

m.addConstr(6.79 * lightbulbs + 6.59 * packs_of_napkins <= 458, name="sustainability_score_10")
m.addConstr(6.79 * lightbulbs + 9.22 * cookies <= 521, name="sustainability_score_11")
m.addConstr(6.79 * lightbulbs + 11.82 * dish_soap_bottles <= 505, name="sustainability_score_12")
m.addConstr(6.79 * lightbulbs + 6.59 * packs_of_napkins + 11.82 * dish_soap_bottles + 9.22 * cookies <= 505, name="sustainability_score_13")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Lightbulbs: {lightbulbs.varValue}")
    print(f"Packs of Napkins: {packs_of_napkins.varValue}")
    print(f"Dish Soap Bottles: {dish_soap_bottles.varValue}")
    print(f"Cookies: {cookies.varValue}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("The model is infeasible.")
