
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Food Cost")

# Create variables
cheeseburgers = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cheeseburgers")
hot_dogs = model.addVar(lb=0, vtype=GRB.INTEGER, name="hot_dogs")

# Set objective function
model.setObjective(3 * cheeseburgers + 6 * hot_dogs, GRB.MINIMIZE)

# Add constraints
model.addConstr(5 * cheeseburgers + 4 * hot_dogs >= 11, "Fat_Lower_Bound")
model.addConstr(5 * cheeseburgers + 4 * hot_dogs <= 40, "Fat_Upper_Bound") # Corrected upper bound
model.addConstr(2 * cheeseburgers + 3 * hot_dogs >= 8, "Calcium_Lower_Bound")
model.addConstr(2 * cheeseburgers + 3 * hot_dogs <= 13, "Calcium_Upper_Bound")
model.addConstr(10 * cheeseburgers - 3 * hot_dogs >= 0, "Custom_Constraint")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Cheeseburgers: {cheeseburgers.x}")
    print(f"Hot Dogs: {hot_dogs.x}")
    print(f"Objective Value: {model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

