
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
cheeseburgers = m.addVar(vtype=GRB.CONTINUOUS, name="cheeseburgers")
hot_dogs = m.addVar(vtype=GRB.INTEGER, name="hot_dogs")

# Objective function: Minimize 3*cheeseburgers + 6*hot_dogs
m.setObjective(3*cheeseburgers + 6*hot_dogs, GRB.MINIMIZE)

# Constraints
# Total fat at least 11 grams
m.addConstr(5*cheeseburgers + 4*hot_dogs >= 11, name="fat_min")

# Total calcium at least 8 milligrams
m.addConstr(2*cheeseburgers + 3*hot_dogs >= 8, name="calcium_min")

# Expression constraint: 10*cheeseburgers - 3*hot_dogs >= 0
m.addConstr(10*cheeseburgers - 3*hot_dogs >= 0, name="expression_constraint")

# Total fat not exceeding 43 grams (using the upper bound from 'r0')
m.addConstr(5*cheeseburgers + 4*hot_dogs <= 43, name="fat_max")

# Total calcium not exceeding 25 milligrams (using the upper bound from 'r1')
m.addConstr(2*cheeseburgers + 3*hot_dogs <= 25, name="calcium_max")

# Optimize
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cheeseburgers: {cheeseburgers.x}")
    print(f"Hot Dogs: {hot_dogs.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
