
import gurobi

def optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    cheeseburgers = model.addVar(lb=0, name="cheeseburgers", vtype=gurobi.GRB.CONTINUOUS)
    hot_dogs = model.addVar(lb=0, name="hot_dogs", vtype=gurobi.GRB.INTEGER)

    # Objective function: Minimize 3 * cheeseburgers + 6 * hot_dogs
    model.setObjective(3 * cheeseburgers + 6 * hot_dogs, gurobi.GRB.MINIMIZE)

    # Constraints
    # At least 11 grams of fat
    model.addConstraint(5 * cheeseburgers + 4 * hot_dogs >= 11, name="fat_min")
    # No more than 43 grams of fat
    model.addConstraint(5 * cheeseburgers + 4 * hot_dogs <= 43, name="fat_max")
    # At least 8 milligrams of calcium
    model.addConstraint(2 * cheeseburgers + 3 * hot_dogs >= 8, name="calcium_min")
    # No more than 25 milligrams of calcium
    model.addConstraint(2 * cheeseburgers + 3 * hot_dogs <= 25, name="calcium_max")
    # Additional constraint: 10 * cheeseburgers - 3 * hot_dogs >= 0
    model.addConstraint(10 * cheeseburgers - 3 * hot_dogs >= 0, name="additional_constraint")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Cheeseburgers: {cheeseburgers.varValue}")
        print(f"Hot Dogs: {hot_dogs.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimization_problem()
