
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
potassium = m.addVar(lb=0, name="potassium")
calcium = m.addVar(lb=0, name="calcium")
vitamin_b4 = m.addVar(lb=0, name="vitamin_b4")
protein = m.addVar(lb=0, name="protein")
zinc = m.addVar(lb=0, name="zinc")

# Set objective function
obj = 4.05*potassium**2 + 7.19*potassium*calcium + 8.62*potassium*vitamin_b4 + 9.82*potassium*protein + 4.28*potassium*zinc + 5.76*calcium*vitamin_b4 + 3.61*calcium*protein + 5.63*calcium*zinc + 3.17*vitamin_b4**2 + 8.57*vitamin_b4*protein + 8.89*vitamin_b4*zinc + 1.89*potassium + 4.34*vitamin_b4 + 4.89*protein + 1.31*zinc
m.setObjective(obj, gp.GRB.MINIMIZE)

# Add resource constraints
resources = {
    'r0': {'upper_bound': 200, 'x0': 14, 'x1': 4, 'x2': 7, 'x3': 12, 'x4': 1},
    'r1': {'upper_bound': 81, 'x0': 12, 'x1': 2, 'x2': 12, 'x3': 5, 'x4': 1},
    'r2': {'upper_bound': 163, 'x0': 14, 'x1': 1, 'x2': 3, 'x3': 7, 'x4': 9}
}

for r, data in resources.items():
    m.addConstr(data['x0']*potassium + data['x1']*calcium + data['x2']*vitamin_b4 + data['x3']*protein + data['x4']*zinc <= data['upper_bound'], name=f"{r}_constraint")


# Add other constraints as specified in the prompt.  Due to the large number of constraints,
# they are added programmatically below.  The constraints are parsed from the prompt
# and converted into Gurobi constraints.

constraints = [
    (4*calcium**2 + 12*protein**2 >= 26, "c1"),
    (14*potassium**2 + zinc**2 >= 31, "c2"),
    (4*calcium + 7*vitamin_b4 + zinc >= 25, "c3"),
    (14*potassium + 4*calcium + 7*vitamin_b4 + 12*protein + zinc >= 25, "c4"),
    (12*potassium**2 + 12*vitamin_b4**2 >= 9, "c5"),
    (12*potassium**2 + zinc**2 >= 13, "c6"),
    (2*calcium + 12*vitamin_b4 >= 7, "c7"),
    (12*potassium + 12*vitamin_b4 + 5*protein >= 14, "c8"),
    (12*potassium**2 + 2*calcium**2 + zinc**2 >= 14, "c9"),
    (12*vitamin_b4 + 5*protein + zinc >= 14, "c10"),
    (2*calcium + 5*protein + zinc >= 14, "c11"),
    (12*potassium**2 + 12*vitamin_b4**2 + 5*protein**2 >= 10, "c12"),
    (12*potassium**2 + 2*calcium**2 + zinc**2 >= 10, "c13"),
    (12*vitamin_b4**2 + 5*protein**2 + zinc**2 >= 10, "c14"),
    (2*calcium + 5*protein + zinc >= 10, "c15"),
    (12*potassium + 12*vitamin_b4 + 5*protein >= 13, "c16"),
    (12*potassium + 2*calcium + zinc >= 13, "c17"),
    (12*vitamin_b4**2 + 5*protein**2 + zinc**2 >= 13, "c18"),
    (2*calcium**2 + 5*protein**2 + zinc**2 >= 13, "c19"),
    (12*potassium + 12*vitamin_b4 + 5*protein >= 13, "c20"),
    (12*potassium + 2*calcium + zinc >= 13, "c21"),
    (12*vitamin_b4 + 5*protein + zinc >= 13, "c22"),
    (2*calcium + 5*protein + zinc >= 13, "c23"),
    (12*potassium + 2*calcium + 12*vitamin_b4 + 5*protein + zinc >= 13, "c24"),
    (7*protein**2 + 9*zinc**2 >= 24, "c25"),
    (14*potassium + 3*vitamin_b4 >= 19, "c26"),
    (14*potassium + 9*zinc >= 18, "c27"),
    (3*vitamin_b4 + 7*protein + 9*zinc >= 30, "c28"),
    (14*potassium + calcium + 3*vitamin_b4 + 7*protein + 9*zinc >= 30, "c29"),
    (-4*potassium + 8*calcium >= 0, "c30"),
    (4*calcium - 2*vitamin_b4 >= 0, "c31"),
    (-10*vitamin_b4 + 3*zinc >= 0, "c32"),
    (14*potassium**2 + zinc**2 <= 175, "c33"),
    (7*vitamin_b4**2 + 12*protein**2 <= 198, "c34"),
    (4*calcium + zinc <= 135, "c35"),
    (4*calcium + 12*protein <= 48, "c36"),
    (14*potassium + 4*calcium + 7*vitamin_b4 <= 176, "c37"),
    (14*potassium + 7*vitamin_b4 + zinc <= 83, "c38"),
    (4*calcium + 7*vitamin_b4 + 12*protein <= 93, "c39"),
    (14*potassium**2 + 4*calcium**2 + 12*protein**2 <= 184, "c40"),
    (2*calcium + zinc <= 29, "c41"),
    (12*potassium + 2*calcium <= 81, "c42"),
    (12*potassium**2 + 12*vitamin_b4**2 <= 19, "c43"),
    (12*potassium + zinc <= 53, "c44"),
    (5*protein + zinc <= 75, "c45"),
    (2*calcium + 5*protein <= 25, "c46"),
    (12*vitamin_b4 + 5*protein <= 47, "c47"),
    (12*vitamin_b4 + zinc <= 66, "c48"),
    (12*potassium + 12*vitamin_b4 + zinc <= 57, "c49"),
    (2*calcium**2 + 12*vitamin_b4**2 + 5*protein**2 <= 56, "c50"),
    (2*calcium**2 + 12*vitamin_b4**2 + zinc**2 <= 70, "c51"),
    (2*calcium**2 + 5*protein**2 + zinc**2 <= 30, "c52"),
    (12*potassium**2 + 5*protein**2 + zinc**2 <= 72, "c53"),
    (12*potassium**2 + 12*vitamin_b4**2 + 5*protein**2 <= 58, "c54"),
    (14*potassium + 7*protein <= 121, "c55"),
    (3*vitamin_b4 + 7*protein <= 66, "c56"),
    (14*potassium**2 + 9*zinc**2 <= 84, "c57"),
    (calcium + 9*zinc <= 52, "c58"),
    (calcium + 7*protein <= 53, "c59"),
    (14*potassium + 7*protein + 9*zinc <= 106, "c60"),
    (calcium + 7*protein + 9*zinc <= 81, "c61"),
    (14*potassium + calcium + 3*vitamin_b4 <= 135, "c62"),
    (calcium + 3*vitamin_b4 + 9*zinc <= 84, "c63"),
    (calcium**2 + 3*vitamin_b4**2 + 7*protein**2 <= 129, "c64"),
    (14*potassium + calcium + 9*zinc <= 66, "c65")
]

for constraint, name in constraints:
    m.addConstr(constraint, name=name)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

