
import gurobi as gp
from gurobi import GRB

# Define variables
K = gp.Var(name="milligrams of potassium", lb=-gp.INF, ub=gp.INF)
C = gp.Var(name="milligrams of calcium", lb=-gp.INF, ub=gp.INF)
B4 = gp.Var(name="milligrams of vitamin B4", lb=-gp.INF, ub=gp.INF)
P = gp.Var(name="grams of protein", lb=-gp.INF, ub=gp.INF)
Z = gp.Var(name="milligrams of zinc", lb=-gp.INF, ub=gp.INF)

# Objective function
obj = 4.05 * K**2 + 7.19 * K * C + 8.62 * K * B4 + 9.82 * K * P + 4.28 * K * Z + \
      5.76 * C * B4 + 3.61 * C * P + 5.63 * C * Z + 3.17 * B4**2 + 8.57 * B4 * P + \
      8.89 * B4 * Z + 1.89 * K + 4.34 * B4 + 4.89 * P + 1.31 * Z

# Model
m = gp.Model()

# Add variables to model
m.addVar(K)
m.addVar(C)
m.addVar(B4)
m.addVar(P)
m.addVar(Z)

# Set objective
m.setObjective(obj, GRB.MINIMIZE)

# Add constraints
# Individual support indices
m.addConstr(14 * K <= 200, name="kidney_support_K")
m.addConstr(12 * K <= 81, name="digestive_support_K")
m.addConstr(14 * K <= 163, name="cardiovascular_support_K")

m.addConstr(4 * C <= 200, name="kidney_support_C")
m.addConstr(2 * C <= 81, name="digestive_support_C")
m.addConstr(C <= 163, name="cardiovascular_support_C")

m.addConstr(7 * B4 <= 200, name="kidney_support_B4")
m.addConstr(12 * B4 <= 81, name="digestive_support_B4")
m.addConstr(3 * B4 <= 163, name="cardiovascular_support_B4")

m.addConstr(12 * P <= 200, name="kidney_support_P")
m.addConstr(5 * P <= 81, name="digestive_support_P")
m.addConstr(7 * P <= 163, name="cardiovascular_support_P")

m.addConstr(Z <= 200, name="kidney_support_Z")
m.addConstr(Z <= 81, name="digestive_support_Z")
m.addConstr(9 * Z <= 163, name="cardiovascular_support_Z")

# ... Add all other constraints similarly

# Solve
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("K: ", K.varValue)
    print("C: ", C.varValue)
    print("B4: ", B4.varValue)
    print("P: ", P.varValue)
    print("Z: ", Z.varValue)
else:
    print("No solution found")
