
import gurobipy as gp

# Create a new model
model = gp.Model("optimize_work_hours")

# Create variables
x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Ringo")
x1 = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hours_worked_by_Jean")

# Set objective function
model.setObjective(8 * x0 + 4 * x1, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(4 * x0 + 3 * x1 >= 10, "c1_likelihood_min")
model.addConstr(4 * x0 + 3 * x1 <= 27, "c2_likelihood_max")
model.addConstr(3 * x0 + 1 * x1 >= 9, "c3_organization_min")
model.addConstr(3 * x0 + 1 * x1 <= 10, "c4_organization_max")
model.addConstr(1 * x0 + 3 * x1 >= 16, "c5_paperwork_min")
model.addConstr(1 * x0 + 3 * x1 <= 30, "c6_paperwork_max")
model.addConstr(3 * x0 + 2 * x1 >= 7, "c7_work_quality_min")
model.addConstr(3 * x0 + 2 * x1 <= 26, "c8_work_quality_max")
model.addConstr(5 * x0 + 1 * x1 >= 7, "c9_computer_min")
model.addConstr(5 * x0 + 1 * x1 <= 19, "c10_computer_max")
model.addConstr(-9 * x0 + 5 * x1 >= 0, "c11")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Hours worked by Ringo: {x0.x}")
    print(f"Hours worked by Jean: {x1.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

