
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the decision variables
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Ringo")
x1 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Jean")

# Objective function: Minimize 8*x0 + 4*x1
m.setObjective(8*x0 + 4*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(4*x0 + 3*x1 >= 10, "Likelihood_to_quit_index_min")
m.addConstr(4*x0 + 3*x1 <= 27, "Likelihood_to_quit_index_max")
m.addConstr(3*x0 + x1 >= 9, "Organization_score_min")
m.addConstr(3*x0 + x1 <= 10, "Organization_score_max")
m.addConstr(x0 + 3*x1 >= 16, "Paperwork_competence_rating_min")
m.addConstr(x0 + 3*x1 <= 30, "Paperwork_competence_rating_max")
m.addConstr(3*x0 + 2*x1 >= 7, "Work_quality_rating_min")
m.addConstr(3*x0 + 2*x1 <= 26, "Work_quality_rating_max")
m.addConstr(5*x0 + x1 >= 7, "Computer_competence_rating_min")
m.addConstr(5*x0 + x1 <= 19, "Computer_competence_rating_max")
m.addConstr(-9*x0 + 5*x1 >= 0, "Additional_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Ringo: {x0.x}")
    print(f"Hours worked by Jean: {x1.x}")
else:
    print("No optimal solution found.")
