
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x_R = m.addVar(name="hours_worked_by_Ringo", lb=0)  # No upper bound given
x_J = m.addVar(name="hours_worked_by_Jean", lb=0, type=gp.GRB.INTEGER)  # Integer constraint

# Define the objective function
m.setObjective(8 * x_R + 4 * x_J, gp.GRB.MINIMIZE)

# Define the constraints
m.addConstr(4 * x_R + 3 * x_J >= 10, name="likelihood_to_quit_index_min")
m.addConstr(4 * x_R + 3 * x_J <= 27, name="likelihood_to_quit_index_max")

m.addConstr(3 * x_R + x_J >= 9, name="organization_score_min")
m.addConstr(3 * x_R + x_J <= 10, name="organization_score_max")

m.addConstr(x_R + 3 * x_J >= 16, name="paperwork_competence_rating_min")
m.addConstr(x_R + 3 * x_J <= 30, name="paperwork_competence_rating_max")

m.addConstr(3 * x_R + 2 * x_J >= 7, name="work_quality_rating_min")
m.addConstr(3 * x_R + 2 * x_J <= 26, name="work_quality_rating_max")

m.addConstr(5 * x_R + x_J >= 7, name="computer_competence_rating_min")
m.addConstr(5 * x_R + x_J <= 19, name="computer_competence_rating_max")

m.addConstr(-9 * x_R + 5 * x_J >= 0, name="jean_vs_ringo_hours")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by Ringo: {x_R.varValue}")
    print(f"Hours worked by Jean: {x_J.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found")
